/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifdef WIN32
#include <afxwin.h>
#endif
#include <stdio.h>              
#include <stdlib.h>             
#include <stddef.h>            
#include <string.h> 
#include <signal.h>
#include "FnKeyApi.h"
#include "AccelApi.h"
#include "DCSApi.h"
#include "PMApi.h"
#ifndef _WIN32
#define Sleep sleep
#endif

#define MAX_BRIGHTNESS 7

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

/* Call back function for Fn Key*/
void CALLBACK DCS_FnKey_handler (DCS_VKbd_Data *pData)
{
	BOOL   bWireless = FALSE;
	int    iBright = 0; 
	printf("DCS_VKbd_Data data: %d \n", *pData);

	switch (*pData)	
	{	
	case FN_WLAN_SWITCH:	
		printf("FN_WLAN_SWITCH\n");
		DCS_GetWirelessStatus(&bWireless);
	
		if(bWireless == FALSE)
		{
			DCS_SetWirelessStatus(TRUE);
			printf("WIRELESS_ON\n");
		}
		else
		{
			DCS_SetWirelessStatus(FALSE);
			printf("WIRELESS_OFF\n");	
		}
	
		break;
	case FN_DISPLAY_SWITCH:	
		printf("FN_DISPLAY_SWITCH\n");
	
		break;
	case FN_BRIGHTNESS_DOWN:	
		DCS_GetLCDBrightness(&iBright);
		if(iBright > 0)
		{
			iBright --;
		}
		DCS_SetLCDBrightness(iBright);
		printf("BRIGHTNESS_DOWN:%d",iBright);
	
		break;
	case FN_BRIGHTNESS_UP:
		DCS_GetLCDBrightness(&iBright);
		if(iBright < MAX_BRIGHTNESS)
		{
			iBright ++;
		}
		DCS_SetLCDBrightness(iBright);
		printf("BRIGHTNESS_UP:%d",iBright);
		break;

	case BEZELBUTTON_SINGLE_CLICK:	
		printf("BEZELBUTTON_SINGLE_CLICK\n");

		break;
	case BEZELBUTTON_DOUBLE_CLICK:	
		printf("BEZELBUTTON_DOUBLE_CLICK\n");

		break;
	default:
		printf("input fn key data is %d \n", *pData);
		break;
	}  
}



int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	int use_timer=0;
	char c0;

	/* Command line parsing */
	for (i=1; i< argc; i++) 
	{
		if (strcmp("-timer", argv[i]) == 0  ) 
		{
			use_timer=1;
		}
	}

	/*initialize the DCS*/
	ret = DCS_Initialize();
	DCS_ReturnValue_handler(ret);
	
	/* For the Fn Key & Button Interface */
	ret=DCS_RegisterFnKeyCallback(DCS_FnKey_handler );
	printf("DCS_RegisterFnKeyCallback\n");
	DCS_ReturnValue_handler(ret);

	/*uninitialize the DCS*/
	int count=0;
	int timer=0;

	if(use_timer==0)
	{
		//Sleep(INFINITE);
		
		while(1) 
		    Sleep(10);
	}
	else
	{
		for(timer=0;timer<=50000;timer++)
		{
			count=0;
			
			Sleep(10);
		}
	}

	ret=DCS_UnregisterFnKeyCallback();
	printf("DCS_UnregisterFnKeyCallback\n");
	DCS_ReturnValue_handler(ret);

	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler(ret);

	return 0;
}

